
 
; Mosquito lure at 484Hz, runs during day for Aedes Aegypti
;  Alternative at 400Hz runs at night for other mozzies

; Mosquito A'lure 
; Australian Institute of Tropical Health and Medicine researchers Brian Johnson and Scott Ritchie discovered a tone of 484 hertz, the frequency of a female Aedes aegypti's wings flapping, 
; attracted male mosquitoes of the species in large numbers. 

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF& _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _XT_OSC	

; bank 0 RAM 

SAMPLE		equ	H'20'	; sample value
LOOP1			equ	H'21'	; timer loop
LOOP2			equ	H'22'	; timer loop
		
; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	nop
	nop
	nop		 
	org    	 4			; interrupt vector
	nop

; ***********************************************************************

MAIN
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf		GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00101110'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'10000000'	; settings (pullups disabled) 
	movwf	OPTION_REG

; analog inputs, A/D
	movlw	B'01110000'	; all IO not analog
	movwf	ANSEL
	
	bsf		IOC,2			; interrupt on change for GP2 input
	bsf		INTCON,GPIE	; port change interrupt enable
	bcf		STATUS,RP0	; select memory bank 0

; add delay

	movlw	D'10'
	movwf	LOOP2
DELAY
	movlw 	D'255'
	movwf	LOOP1
LOOP
	decfsz	LOOP1,f
	goto	LOOP
	decfsz	LOOP2,f
	goto	DELAY

; check GP1 input. If low then 484Hz, if high 400Hz

	btfsc	GPIO,1
	goto	RUN_400Hz_NIGHT ; (generate 400Hz during night)

RUN_484Hz_DAY ; (generate 484Hz during day)	
; GP1  an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00101100'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

; check GP2
CHECK_GP2_484
; GPIO,2 (runs output frequency when low)
; no signal produced when GPIO,2 is high (GP0 is set low to place amplifier in standby)
	btfss	GPIO,2
	goto	SINE0_484
; 
; stop
NIGHT
	movf	GPIO,w			; read ports
	bcf		INTCON,GPIF	; clear flag
	clrf		GPIO			; outputs low
	SLEEP
	nop						; awakes on GP2 change via port change interrupt
	movf	GPIO,w			; read ports
	bcf		INTCON,GPIF	; clear flag
	goto	CHECK_GP2_484

; table for 484Hz sine wave
; PWM on (high) time (cycles) (using 64 x 1us cycles over 32 counts has 2048 cycles so add 1 every second* counter plus another at counter12 ** and 20 ** for 2066 cycles total (484Hz)
	
		; 32 clocks 					    counter0  	0 degrees (0.5 sinx +0.5) x 64 gives required PWM value 

		; 38 clocks 	plus 1*			    counter1	11.25 degrees
		; 44 clocks					    counter2	22.5
		; 50 clocks	plus 1*			    counter3	33.75
		; 55 clocks					    counter4	45
		; 59 clocks	plus 1*			    counter5	56.25
		; 62 clocks					    counter6	67.5
		; 63 clocks	plus 1*			    counter7	78.75
		; 64 clocks					    counter8	90 degrees

		; 63 clocks	plus 1*			    counter9	101.25
		; 62 clocks					    counter10	112.5	
		; 59 clocks	plus 1*			    counter11	123.75
		; 55 clocks	plus 1**			    counter12	135
		; 50 clocks	plus 1*			    counter13	146.25
		; 44 clocks					    counter14	157.5
		; 38 clocks	plus 1*			    counter15	168.75

		; 32 clocks					    counter16  180 degrees 

		; 26 clocks 	plus 1*			    counter17   191.25 degrees
		; 20 clocks					    counter18   202.5
		; 14 clocks	plus 1*			    counter19	213.75
		; 9 clocks					    counter20	225
		; 5 clocks	plus 1*			    counter21	236.25
		; 2 clocks					    counter22	247.5
		; 1 clocks	plus 1*			    counter23	258.755
		; 0 clocks					    counter24	270 degrees

		; 1 clocks	plus 1*			    counter25	281.25
		; 2 clocks					    counter26	292.5
		; 5 clocks	plus 1*			    counter27	303.75
		; 9 clocks	plus 1**			    counter28	315
		; 14 clocks	plus 1*			    counter29	326.25
		; 20 clocks					    counter30	337.5
		; 26 clocks	plus 1*			    counter31	348.75 degrees

 ; off period for PWM (Low)

		; 32 clocks 					    counter0  0 degrees 
		; 26 clocks 					    counter1   
		; 20 clocks					    counter2	
		; 14 clocks					    counter3	
		; 9 clocks					    counter4
		; 5 clocks					    counter5
		; 2 clocks					    counter6	
		; 1 clocks					    counter7	
		; 0 clocks					    counter8	90 degrees

		; 1 clocks					    counter9	
		; 2 clocks					    counter10	
		; 5 clocks					    counter11	
		; 9 clocks					    counter12	
		; 14 clocks					    counter13	
		; 20 clocks					    counter14	
		; 26 clocks					    counter15	
	
		; 32 clocks					    counter16  	180 degrees
		; 38 clocks  					    counter17	
		; 44 clocks					    counter18	
		; 50 clocks					    counter19	
		; 55 clocks					    counter20	
		; 59 clocks					    counter21	
		; 62 clocks					    counter22	
		; 63 clocks					    counter23
		; 64 clocks					    counter24	270 degrees

		; 63 clocks					    counter25	
		; 62 clocks					    counter26	
		; 59 clocks					    counter27	
		; 55 clocks					    counter28	
		; 50 clocks					    counter29	
		; 44 clocks					    counter30	
		; 38 clocks					    counter31	

SINE0_484 ; runs 484Hz    
; start at 0 degrees with 50% duty for 64 cycles ie on 32 off 32
; Output at GP1, GP0 is the enable (when high) for the amplifier

; COUNTER0----------------------------------------------
		; 32 clocks 					    counter0  	0 degrees 	
;0  GP1 low for 32, 1us cycles
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
; check LDR
	btfsc	GPIO,2
	goto	NIGHT 
; compensated loop period
H0	decfsz	SAMPLE,f
	goto	H0
;, GP1 high for 32 1us cycles	
		; 32 clocks 					    counter0  0 degrees 	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L0	decfsz	SAMPLE,f
	goto	L0

; COUNTER1----------------------------------------------
		; 38 clocks plus 1*				    counter1	11.25 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H1	decfsz	SAMPLE,f
	goto	H1
 		; 26 clocks 					    counter1   
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L1	decfsz	SAMPLE,f
	goto	L1

;COUNTER2----------------------------------------------
	; 44 clocks					    counter2	22.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'13'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H2	decfsz	SAMPLE,f
	goto	H2
 		; 20 clocks					    counter2		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'5'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L2	decfsz	SAMPLE,f
	goto	L2

;COUNTER3----------------------------------------------
		; 50 clocks	plus 1*			    counter3	33.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'15'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H3	decfsz	SAMPLE,f
	goto	H3
 		; 14 clocks					    counter3		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'3'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L3	decfsz	SAMPLE,f
	goto	L3

;COUNTER4----------------------------------------------
		; 55 clocks					    counter4	45	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'17'
	movwf	SAMPLE
	nop
; compensated loop period
H4	decfsz	SAMPLE,f
	goto	H4
 		; 9 clocks					    counter4	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE

; compensated loop period
L4	decfsz	SAMPLE,f
	goto	L4

;COUNTER5----------------------------------------------
		; 59 clocks	plus 1*			    counter5	56.25	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'18'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H5	decfsz	SAMPLE,f
	goto	H5
		; 5 clocks					    counter5 
	movlw	B'00000011'
	movwf	GPIO
	nop
	nop
	nop

;COUNTER6----------------------------------------------
	; 62 clocks					    counter6	67.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H6	decfsz	SAMPLE,f
	goto	H6
		; 2 clocks					    counter6	
	movlw	B'00000011'
	movwf	GPIO

;COUNTER7----------------------------------------------	
; 63 clocks plus 1*					    counter7	78.75 degrees

	movlw	B'00000001'
	movwf	GPIO
	movlw	D'20'
	movwf	SAMPLE
	movlw	B'00000011'
; compensated loop period
H7	decfsz	SAMPLE,f
	goto	H7
		;  1 clock				    counter7
	movwf	GPIO

;COUNTER8----------------------------------------------	
	; 64 clocks					    counter8	90 degrees

	movlw	B'00000001'
	movwf	GPIO
	movlw	D'20'
	movwf	SAMPLE
	nop
	nop
H8	decfsz	SAMPLE,f
	goto	H8
	; 0 clocks					    counter8	90 degrees

;COUNTER9----------------------------------------------	
		; 63 clocks	plus 1*			    counter9	101.25 degrees
	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'20'
	movwf	SAMPLE
	movlw	B'00000011'
; compensated loop period
H9	decfsz	SAMPLE,f
	goto	H9
		; 1 clock					    counter9	
	movwf	GPIO

;COUNTER10----------------------------------------------
		; 62 clocks					    counter10	112.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H10	decfsz	SAMPLE,f
	goto	H10
		; 2 clocks					    counter10	
	movlw	B'00000011'
	movwf	GPIO

;COUNTER11----------------------------------------------

		; 59 clocks	plus 1*			    counter11	123.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'18'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H11	decfsz	SAMPLE,f
	goto	H11
		; 5 clocks					    counter11 
	movlw	B'00000011'
	movwf	GPIO
	nop
	nop
	nop

;COUNTER12----------------------------------------------
		; 55 clocks	plus 1**			    counter12	135
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'17'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H12	decfsz	SAMPLE,f
	goto	H12
 		; 9 clocks					    counter12	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE

; compensated loop period
L12	decfsz	SAMPLE,f
	goto	L12

;COUNTER13----------------------------------------------
	; 50 clocks	plus 1*			    counter13	146.25
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'15'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H13	decfsz	SAMPLE,f
	goto	H13
 		; 14 clocks					    counter13		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'3'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L13	decfsz	SAMPLE,f
	goto	L13

;COUNTER14----------------------------------------------
	; 44 clocks					    counter14	157.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'13'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H14	decfsz	SAMPLE,f
	goto	H14
 		; 20 clocks					    counter14		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'5'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L14	decfsz	SAMPLE,f
	goto	L14

;COUNTER15----------------------------------------------
		; 38 clocks	plus 1*			    counter15	168.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H15	decfsz	SAMPLE,f
	goto	H15
 		; 26 clocks 					    counter15 
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L15	decfsz	SAMPLE,f
	goto	L15

;COUNTER16----------------------------------------------
		; 32 clocks					    counter16  180 degrees 
;0 GP0 high, GP1 low for 32, 1us cycles
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H16	decfsz	SAMPLE,f
	goto	H16
;0 GP0 low, GP1 high for 32 1us cycles	
		; 32 clocks 					    counter16  180 degrees 	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L16	decfsz	SAMPLE,f
	goto	L16

; lower half of sine wave for GP0, upper half for GP1

;COUNTER17----------------------------------------------
		; 26 clocks 	plus 1*			    counter17   191.25 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H17	decfsz	SAMPLE,f
	goto	H17
	; 38 clocks  					    counter17	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L17	decfsz	SAMPLE,f
	goto	L17
 
;COUNTER18----------------------------------------------
		; 20 clocks					    counter18   202.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'5'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H18	decfsz	SAMPLE,f
	goto	H18
	; 44 clocks					    counter18
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'13'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L18	decfsz	SAMPLE,f
	goto	L18
 
;COUNTER19----------------------------------------------
		; 14 clocks	plus 1*			    counter19	213.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'3'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H19	decfsz	SAMPLE,f
	goto	H19
	; 50 clocks					    counter19	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'15'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L19	decfsz	SAMPLE,f
	goto	L19
 
;COUNTER20----------------------------------------------
		; 9 clocks				    counter20	225	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE

; compensated loop period
H20	decfsz	SAMPLE,f
	goto	H20
	; 55 clocks					    counter20	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'17'
	movwf	SAMPLE
; compensated loop period
L20	decfsz	SAMPLE,f
	goto	L20
 
;COUNTER21----------------------------------------------
		; 5 clocks	plus 1*		    counter21	236.25	
	movlw	B'00000001'
	movwf	GPIO
	nop
	nop
	nop
	nop
	; 59 clocks					    counter21
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'18'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L21	decfsz	SAMPLE,f
	goto	L21

;COUNTER22----------------------------------------------	
		; 2 clocks					    counter22	247.5
	movlw	B'00000001'
	movwf	GPIO
	; 62 clocks					    counter22
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L22	decfsz	SAMPLE,f
	goto	L22

;COUNTER23----------------------------------------------	
		; 1 clocks	plus 1*			    counter23	258.755	
	movlw	B'00000001'
	movwf	GPIO
	; 63 clocks					    counter23
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'20'
	movwf	SAMPLE
; compensated loop period
L23	decfsz	SAMPLE,f
	goto	L23

;COUNTER24----------------------------------------------
		; 0 clocks					    counter24	270 degrees
	; 64 clocks					    counter24	270 degrees
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'20'
	movwf	SAMPLE
	nop
	nop
H24	decfsz	SAMPLE,f
	goto	H24

;COUNTER25----------------------------------------------
		; 1 clocks	plus 1*			    counter25	281.25
	movlw	B'00000001'
	movwf	GPIO
	; 63 clocks					    counter25
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'20'
	movwf	SAMPLE
; compensated loop period
L25	decfsz	SAMPLE,f
	goto	L25

;COUNTER26----------------------------------------------
		; 2 clocks					    counter26	292.5
	movlw	B'00000001'
	movwf	GPIO
	; 62 clocks					    counter26
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L26	decfsz	SAMPLE,f
	goto	L26

;COUNTER27----------------------------------------------
		; 5 clocks	plus 1*			    counter27	303.75
	movlw	B'00000001'
	movwf	GPIO
	nop
	nop
	nop
	nop
	; 59 clocks					    counter27
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'18'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L27	decfsz	SAMPLE,f
	goto	L27

;COUNTER28----------------------------------------------	
		; 9 clocks	plus 1**			    counter28	315
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H28	decfsz	SAMPLE,f
	goto	H28
	; 55 clocks					    counter28	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'17'
	movwf	SAMPLE
; compensated loop period
L28	decfsz	SAMPLE,f
	goto	L28

;COUNTER29----------------------------------------------
		; 14 clocks	plus 1*			    counter29	326.25
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'3'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H29	decfsz	SAMPLE,f
	goto	H29
	; 50 clocks					    counter29	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'15'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L29	decfsz	SAMPLE,f
	goto	L29
;COUNTER30----------------------------------------------	
		; 20 clocks				    counter30	337.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'5'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H30	decfsz	SAMPLE,f
	goto	H30
	; 44 clocks					    counter30
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'13'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L30	decfsz	SAMPLE,f
	goto	L30
;COUNTER31----------------------------------------------	
		; 26 clocks	plus 1*			    counter31	348.75 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H31	decfsz	SAMPLE,f
	goto	H31
	; 38 clocks  					    counter31	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'10'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L31	decfsz	SAMPLE,f
	goto	L31
	
	goto	SINE0_484
	
	
;___________________________________________________________________________________________________________________________________
	
	
	
; table for 400Hz sine wave
; PWM on (high) time (cycles) (using 78 x 1us cycles over 32 counts has 2496 cycles so add 1 every 8th counter plus for 2500 cycles total (400Hz)

; on period (on period plus off period = 78 clocks)	
	
		; 39 clocks 					    counter0  	0 degrees (0.5 sinx +0.5) x 78 gives required PWM value 

		; 46 clocks 					    counter1	11.25 degrees
		; 54clocks					    counter2	22.5
		; 61 clocks					    counter3	33.75
		; 67 clocks					    counterB45
		; 71 clocks					    counter5	56.25
		; 75 clocks					    counter6	67.5
		; 77 clocks					    counter7	78.75
		; 78 clocks					    counter8	90 degrees

		; 77 clocks					    counter9	101.25
		; 75	clocks				            counter10	112.5		
		; 71 clocks					    counter11	123.75
		; 67 clocks					    counter12	135
		; 61 clocks					    counter13	146.25
		; 54 clocks					    counter1B157.5
		; 46 clocks				            counter15	168.75

		; 39 clocks					    counter16  180 degrees 

		; 32 clocks 				    	    counter17   191.25 degrees
		; 24 clocks					    counter18   202.5
		; 17 clocks				    	    counter19	213.75
		; 11 clocks					    counter20	225
		; 7 clocks				            counter21	236.25
		; 3 clocks					    counter22	247.5
		; 1 clocks				            counter23	258.755
		; 0 clocks					    counter2B270 degrees

		; 1 clocks				    	    counter25	281.25
		; 3 clocks					    counter26	292.5
		; 7 clocks				    	    counter27	303.75
		; 11 clocks				            counter28	315
		; 17 clocks				            counter29	326.25
		; 24 clocks					    counter30	337.5
		; 32 clocks				            counter31	348.75 degrees

 ; off period for PWM (Low)

		; 39 clocks 					    counter0  0 degrees 
		; 32 clocks 					    counter1   
		; 24 clocks					    counter2	
		; 17 clocks					    counter3	
		; 11clocks					    counter4
		; 7 clocks					    counter5
		; 3 clocks					    counter6	
		; 1 clocks					    counter7	
		; 0 clocks					    counter8	90 degrees

		; 1 clocks					    counter9	
		; 3 clocks					    counter10	
		; 7 clocks					    counter11	
		; 11clocks					    counter12	
		; 17 clocks					    counter13	
		; 24 clocks					    counter1B
		; 32 clocks					    counter15	
	
		; 39 clocks					    counter16  	180 degrees
	
		; 46 clocks  					    counter17	
		; 54 clocks					    counter18	
		; 61 clocks					    counter19	
		; 67 clocks					    counter20	
		; 71 clocks					    counter21	
		; 75 clocks					    counter22	
		; 77 clocks					    counter23
		; 78 clocks					    counter2B270 degrees

		; 77 clocks					    counter25	
		; 75 clocks					    counter26	
		; 71 clocks					    counter27	
		; 67 clocks					    counter28	
		; 61 clocks					    counter29	
		; 54 clocks					    counter30	
		; 46 clocks					    counter31	


; 400Hz version
RUN_400Hz_NIGHT
	
; GP1  an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00101100'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0

; check GP2
CHECK_GP2_400
; GPIO,2 (runs output frequency when high)
; no signal produced when GPIO,2 is low (GP0 is set low to place amplifier in standby)
	btfsc	GPIO,2
	goto	SINE0_400	; run   400Hz               
; 
; stop
NIGHT_400 ; 400Hz run at night version
	movf	GPIO,w			; read ports
	bcf		INTCON,GPIF	; clear flag
	clrf		GPIO			; outputs low
	SLEEP
	nop						; awakes on GP2 change via port change interrupt
	movf	GPIO,w			; read ports
	bcf		INTCON,GPIF	; clear flag
	goto	CHECK_GP2_400

SINE0_400; 400Hz
; start at 0 degrees with 50% duty for 78 cycles ie on 39 off 39
; Output at GP1, GP0 is the enable (when high) for the amplifier

; COUNTER0----------------------------------------------
		; 39 clocks 					    counter0  	0 degrees 	
;0  GP1 low for 39, 1us cycles
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE	
	nop
; check LDR
	btfss	GPIO,2
	goto	NIGHT_400 
;	nop		; 'nop' required when btfss GPIO,2  and GOTO  NIGHT_400  are remarked out
;	nop		; 'nop' required when btfss GPIO,2  and GOTO  NIGHT_400  remarked out

; compensated loop period
H0B
	decfsz	SAMPLE,f
	goto	H0B
;, GP1 high for 39 1us cycles	
		; 39 clocks 					    counter0  0 degrees 	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
L0B
	decfsz	SAMPLE,f
	goto	L0B

; COUNTER1----------------------------------------------
		; 46 clocks 			    counter1	11.25 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'14'
	movwf	SAMPLE
	nop
; compensated loop period
H1B
	decfsz	SAMPLE,f
	goto	H1B
 		; 32 clocks 					    counter1   
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L1B
	decfsz	SAMPLE,f
	goto	L1B

;COUNTER2----------------------------------------------
	; 54 clocks					    counter2	22.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'16'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H2B
	decfsz	SAMPLE,f
	goto	H2B
 		; 24 clocks					    counter2		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
; compensated loop period
L2B
	decfsz	SAMPLE,f
	goto	L2B

;COUNTER3----------------------------------------------
		; 61 clocks		    counter3	33.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
; compensated loop period
H3B
	decfsz	SAMPLE,f
	goto	H3B
 		; 17 clocks					    counter3		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'4'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L3B
	decfsz	SAMPLE,f
	goto	L3B

;COUNTER4----------------------------------------------
		; 67 clocks plus 1					    counterB45	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'21'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H4B
	decfsz	SAMPLE,f
	goto	H4B
 		; 11 clocks					    counterB
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE
	nop
	nop

; compensated loop period
L4B
	decfsz	SAMPLE,f
	goto	L4B

;COUNTER5----------------------------------------------
		; 71  clocks			    counter5	56.25	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'22'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H5B
	decfsz	SAMPLE,f
	goto	H5B
		; 7 clocks					    counter5 
	movlw	B'00000011'
	movwf	GPIO
	nop
	nop
	nop
	nop
	nop

;COUNTER6----------------------------------------------
	; 75 clocks					    counter6	67.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'23'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H6B
	decfsz	SAMPLE,f
	goto	H6B
		; 3 clocks					    counter6	
	movlw	B'00000011'
	movwf	GPIO
	nop

;COUNTER7----------------------------------------------	
	; 77 clocks					    counter7	78.75 degrees

	movlw	B'00000001'
	movwf	GPIO
	movlw	D'24'
	movwf	SAMPLE
	nop
	movlw	B'00000011'
; compensated loop period
H7B
	decfsz	SAMPLE,f
	goto	H7B
		;  1 clock				    counter7
	movwf	GPIO

;COUNTER8----------------------------------------------	
	; 78 clocks					    counter8	90 degrees

	movlw	B'00000001'
	movwf	GPIO
	movlw	D'24'
	movwf	SAMPLE
	nop
	nop
	nop
H8B
	decfsz	SAMPLE,f
	goto	H8B
	; 0 clocks					    counter8	90 degrees

;COUNTER9----------------------------------------------	
		; 77 clocks			    counter9	101.25 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'24'
	movwf	SAMPLE
	nop
	movlw	B'00000011'
; compensated loop period
H9B
	decfsz	SAMPLE,f
	goto	H9B
		; 1 clock					    counter9	
	movwf	GPIO

;COUNTER10----------------------------------------------
		;75 clocks					    counter10	112.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'23'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H10B 
	decfsz	SAMPLE,f
	goto	H10B
		; 3 clocks					    counter10	
	movlw	B'00000011'
	movwf	GPIO
	nop

;COUNTER11----------------------------------------------
		; 71 clocks	plus 1*			    counter11	123.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'22'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H11B
	decfsz	SAMPLE,f
	goto	H11B
		; 7 clocks					    counter11 
	movlw	B'00000011'
	movwf	GPIO
	nop
	nop
	nop
	nop
	nop

;COUNTER12----------------------------------------------
		; 67 clocks	plus 1*			    counter12	135
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'21'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H12B
	decfsz	SAMPLE,f
	goto	H12B
 		; 11clocks					    counter12	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L12B
	decfsz	SAMPLE,f
	goto	L12B

;COUNTER13----------------------------------------------
	; 61 clocks				    counter13	146.25
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
; compensated loop period
H13B
	decfsz	SAMPLE,f
	goto	H13B
 		; 17 clocks					    counter13		
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'4'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L13B
	 decfsz	SAMPLE,f
	goto	L13B

;COUNTER14----------------------------------------------
	; 54 clocks					    counter1B157.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'16'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H14B
	 decfsz	SAMPLE,f
	goto	H14B
 		; 24 clocks					    counter1B	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
; compensated loop period
L14B
	decfsz	SAMPLE,f
	goto	L14B

;COUNTER15----------------------------------------------
		; 46 clocks		    counter15	168.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'14'
	movwf	SAMPLE
	nop
; compensated loop period
H15B
	decfsz	SAMPLE,f
	goto	H15B
 		; 32 clocks 					    counter15 
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L15B
	decfsz	SAMPLE,f
	goto	L15B

;COUNTER16----------------------------------------------
		; 39 clocks					    counter16  180 degrees 
;0 GP0 high, GP1 low for 32, 1us cycles
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
H16B
	decfsz	SAMPLE,f
	goto	H16B
;0 GP0 low, GP1 high for 32 1us cycles	
		; 39 clocks 					    counter16  180 degrees 	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'11'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
L16B
	decfsz	SAMPLE,f
	goto	L16B

;..............................................................................................................................................

; lower half of sine wave for GP0, upper half for GP1

;COUNTER17----------------------------------------------
		; 32 clocks 	    counter17   191.25 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H17B
	decfsz	SAMPLE,f
	goto	H17B
	; 46 clocks  					    counter17	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'14'
	movwf	SAMPLE
	nop
; compensated loop period
L17B
	decfsz	SAMPLE,f
	goto	L17B

;COUNTER18----------------------------------------------
		; 24 clocks					    counter18   202.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
; compensated loop period
H18B
	 decfsz	SAMPLE,f
	goto	H18B
	; 54 clocks					    counter18
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'16'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
L18B
	decfsz	SAMPLE,f
	goto	L18B
 
;COUNTER19----------------------------------------------
		; 17 clocks			    counter19	213.75
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'4'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H19B
	decfsz	SAMPLE,f
	goto	H19B
	; 61 clocks					    counter19	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
; compensated loop period
L19B
	decfsz	SAMPLE,f
	goto	L19B
 
;COUNTER20----------------------------------------------
		; 11 clocks	+1			    counter20	225	
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H20B
	decfsz	SAMPLE,f
	goto	H20B
	; 67 clocks					    counter20	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'21'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L20B
	decfsz	SAMPLE,f
	goto	L20B

;COUNTER21----------------------------------------------
		; 7 clocks		    counter21	236.25	
	movlw	B'00000001'
	movwf	GPIO
	nop
	nop
	nop
	nop
	nop
	; 71 clocks					    counter21
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'22'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L21B
	decfsz	SAMPLE,f
	goto	L21B

;COUNTER22----------------------------------------------	
		; 3 clocks					    counter22	247.5
	movlw	B'00000001'
	movwf	GPIO
	nop
	; 75 clocks					    counter22
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'23'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
L22B
	decfsz	SAMPLE,f
	goto	L22B

;COUNTER23----------------------------------------------	
		; 1 clock			    counter23	258.755	
	movlw	B'00000001'
	movwf	GPIO
	; 77 clocks					    counter23
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'24'
	movwf	SAMPLE
	nop
; compensated loop period
L23B
	decfsz	SAMPLE,f
	goto	L23B

;COUNTER24----------------------------------------------
		; 0 clocks					    counter2B270 degrees
	; 78 clocks					    counter2B270 degrees
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'24'
	movwf	SAMPLE
	nop
	nop
	nop
H24B
	decfsz	SAMPLE,f
	goto	H24B

;COUNTER25----------------------------------------------
		; 1 clock			    counter25	281.25
	movlw	B'00000001'
	movwf	GPIO
	; 77 clocks					    counter25
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'24'
	movwf	SAMPLE
	nop
; compensated loop period
L25B
	decfsz	SAMPLE,f
	goto	L25B

;COUNTER26----------------------------------------------
		; 2 clocks					    counter26	292.5
	movlw	B'00000001'
	movwf	GPIO
	nop
	; 75 clocks					    counter26
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'23'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
L26B
	 decfsz	SAMPLE,f
	goto	L26B

;COUNTER27----------------------------------------------
		; 7 clocks				    counter27	303.75
	movlw	B'00000001'
	movwf	GPIO
	nop
	nop
	nop
	nop
	nop
	; 71 clocks					    counter27
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'22'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L27B
	decfsz	SAMPLE,f
	goto	L27B

;COUNTER28----------------------------------------------	
		; 11 clocks	 plus 1				    counter28	315
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'2'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H28B
	decfsz	SAMPLE,f
	goto	H28B
	; 67 clocks					    counter28	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'21'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L28B
	decfsz	SAMPLE,f
	goto	L28B

;COUNTER29----------------------------------------------
		; 17 clocks			    counter29	326.25
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'4'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H29B
	decfsz	SAMPLE,f
	goto	H29B
	; 61 clocks					    counter29	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'19'
	movwf	SAMPLE
	nop
; compensated loop period
L29B
	decfsz	SAMPLE,f
	goto	L29B

;COUNTER30----------------------------------------------	
		; 24 clocks				    counter30	337.5
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'7'
	movwf	SAMPLE
; compensated loop period
H30B
	decfsz	SAMPLE,f
	goto	H30B
	; 54 clocks					    counter30
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'16'
	movwf	SAMPLE
	nop
	nop
	nop
; compensated loop period
L30B
	decfsz	SAMPLE,f
	goto	L30B

;COUNTER31----------------------------------------------	
		; 32 clocks				    counter31	348.75 degrees
	movlw	B'00000001'
	movwf	GPIO
	movlw	D'9'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
H31B
	decfsz	SAMPLE,f
	goto	H31B
	; 46 clocks  					    counter31	
	movlw	B'00000011'
	movwf	GPIO
	movlw	D'13'
	movwf	SAMPLE
	nop
	nop
; compensated loop period
L31B
	decfsz	SAMPLE,f
	goto	L31B


	goto	SINE0_400



	end
